<?php
/**
 * SharkGate - SharkActiveDefence
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 *
 * @category    SharkGate
 * @package     SharkGate_SharkActiveDefence
 * @author      Nikola Jocic
 * @copyright   Copyright (c) 2017 SharkGate LTD (http://www.sharkgate.net)
 * @license     http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */

class RecursiveCallbackFilterIterator extends RecursiveFilterIterator 
{
 
     /**
     * 
     *
     * @return void
     */   
    public function __construct ( RecursiveIterator $iterator, $callback ) {        
        $this->callback = $callback;        

        parent::__construct($iterator);        
    }

     /**
     * 
     *
     * @return void
     */       
    public function accept () {        
        $callback = $this->callback;  

        return $callback(parent::current(), parent::key(), parent::getInnerIterator());        
    }

     /**
     * 
     *
     * @return void
     */       
    public function getChildren () {        
        return new self($this->getInnerIterator()->getChildren(), $this->callback);        
    }
    
}