<?php
class Emipro_CustomoptionsImages_Model_Product_Option extends Mage_Catalog_Model_Product_Option
{
	 const OPTION_TYPE_THUMBGALLERY  = 'thumb_gallery';
    const OPTION_TYPE_THUMBPOPUP  = 'thumb_gallery_popup';
    const OPTION_TYPE_THUMBGALLERY_MULTIPLE  = 'thumb_gallery_multiple';

    const OPTION_GROUP_INSTAGRAMIMAGE       = 'instagramimage';
    const OPTION_TYPE_INSTAGRAMIMAGE_TYPE   = 'instagramimage_type';


    const OPTION_GROUP_GALLERY = 'gallery';
    /**
     * Get group name of option by given option type
     *
     * @param string $type
     * @return string
     */
    public function getGroupByType($type = null)
    {
        if (is_null($type)) {
            $type = $this->getType();
        }
        $optionGroupsToTypes = array(
            self::OPTION_TYPE_FIELD => self::OPTION_GROUP_TEXT,
            self::OPTION_TYPE_AREA => self::OPTION_GROUP_TEXT,
            self::OPTION_TYPE_FILE => self::OPTION_GROUP_FILE,
            self::OPTION_TYPE_DROP_DOWN => self::OPTION_GROUP_SELECT,
            self::OPTION_TYPE_RADIO => self::OPTION_GROUP_SELECT,
            self::OPTION_TYPE_CHECKBOX => self::OPTION_GROUP_SELECT,
            self::OPTION_TYPE_MULTIPLE => self::OPTION_GROUP_SELECT,
            self::OPTION_TYPE_DATE => self::OPTION_GROUP_DATE,
            self::OPTION_TYPE_DATE_TIME => self::OPTION_GROUP_DATE,
            self::OPTION_TYPE_TIME => self::OPTION_GROUP_DATE,

            self::OPTION_TYPE_THUMBPOPUP => self::OPTION_GROUP_SELECT,
            self::OPTION_TYPE_THUMBGALLERY => self::OPTION_GROUP_SELECT,
            self::OPTION_TYPE_THUMBGALLERY_MULTIPLE => self::OPTION_GROUP_SELECT,
        );

        return isset($optionGroupsToTypes[$type])?$optionGroupsToTypes[$type]:'';
    }	
     public function groupFactory($type)
    {
        if( $type === self::OPTION_TYPE_THUMBGALLERY ||  $type === self::OPTION_TYPE_THUMBPOPUP ||  $type === self::OPTION_TYPE_THUMBGALLERY_MULTIPLE){
            return Mage::getModel('Mage_Catalog_Model_Product_Option_Type_Select');
        }
        return parent::groupFactory($type);
    }
    
}
