<?php

/**
 * @author Ultiminio Ramos
 * @since 2014-08-12
 */
class Magen4me_BanwireOxxo_Model_Oxxo extends Mage_Payment_Model_Method_Abstract
{

    const BANWIRE_OXXO_MEDIA_FOLDER = 'banwire/oxxo_PXF5918/';
    const BANWIRE_OXXO_CODE = 'banwireOxxo';
    const BANWIRE_OXXO_INFOBLOCKTYPE = 'banwireOxxo/info_oxxo';
    const BANWIRE_OXXO_FORMBLOCKTYPE = 'banwireOxxo/offline';
    const BANWIRE_OXXO_DIRLOG = '/Payment/Banwire/';
    const XML_PATH_BANWIRE_OXXO_EMAIL_TEMPLATE = 'payment/banwireOxxo/email_template'; //payment_banwireOxxo_email_template

    /**
     * $templateId can be set to numeric or string type value.
     * You can use Id of transactional emails (found in
     * "System->Trasactional Emails"). But better practice is
     * to create a config for this and use xml path to fetch
     * email template info (whatever from file/db).
     */

    /**
     * unique internal payment method identifier
     *
     * @var string [a-z0-9_]
     */
    protected $_code = self::BANWIRE_OXXO_CODE;
    protected $_infoBlockType = self::BANWIRE_OXXO_INFOBLOCKTYPE;
    protected $_formBlockType = self::BANWIRE_OXXO_FORMBLOCKTYPE;

    /**
     * Here are examples of flags that will determine functionality availability
     * of this module to be used by frontend and backend.
     *
     * @see all flags and their defaults in Mage_Payment_Model_Method_Abstract
     *
     * It is possible to have a custom dynamic logic by overloading
     * public function can* for each flag respectively
     */

    /**
     * Is this payment method a gateway (online auth/charge) ?
     */
    protected $_isGateway = true;

    /**
     * Can authorize online?
     */
    protected $_canAuthorize = true;

    /**
     * Can capture funds online?
     */
    protected $_canCapture = false;

    /**
     * Can capture partial amounts online?
     */
    protected $_canCapturePartial = false;

    /**
     * Can refund online?
     */
    protected $_canRefund = false;

    /**
     * Can void transactions online?
     */
    protected $_canVoid = true;

    /**
     * Can use this payment method in administration panel?
     */
    protected $_canUseInternal = true;

    /**
     * Can show this payment method as an option on checkout payment page?
     */
    protected $_canUseCheckout = true;

    /**
     * Is this payment method suitable for multi-shipping checkout?
     */
    protected $_canUseForMultishipping = true;

    /**
     * URL del webservice
     *
     * @var string
     */
    private $_host = 'https://www.banwire.com/api.oxxo';

    /**
     * Usuario para conectarse a la API de Banwire/Oxxo.
     *
     * @var string
     */
    private $_user = 'desarrollo';

    /**
     * Bandera para indicar si se va a enviar el correo de confirmación desde Banwire o no.
     *
     * @var bool
     */
    private $_sendPdf = FALSE;

    /**
     * URL para cachar la respuesta de oxxo.
     *
     * @var string
     */
    private $_urlResponse = 'banwire_UFC3920/oxxo/catch_response.php';

    /**
     * Ruta donde se almacenara la imagen del código de barras.
     *
     * @var string
     */
    private $_path = '/';

    /**
     * Días de vigencia del talón de pago.
     *
     * @var int
     */
    private $_daysInForce = 7;
    private $_sendSeparateStub = 0;

    /**
     * Si se debe guardar el registro de eventos en un archivo log.
     *
     * @var int
     */
    private $_bitacoras = 1;
    private $_dirLog = '';

    /**
     * Array contenedor de parametros para la API.
     *
     * @var array
     */
    private $_params = array(
        'usuario' => NULL, // Nombre del usuario en BanWire.
        'referencia' => NULL, // Referencia de la transacción.
        'dias_vigencia' => NULL, // Días que tendrá para realizar el pago, máximo 10 días.
        'monto' => NULL, // Monto a cobrar, máximo 10000.
        'url_respuesta' => NULL, // URL a donde se mandara el POST de la respuesta.
        'cliente' => NULL, // Nombre del cliente.
        'formato' => 'JSON', // Formato de la comunicación JSON | HTTPQUERY.
        'email' => NULL, // Si sendPDF es TRUE, manda el recibo de pago a este correo.
        'sendPDF' => FALSE // Indica si BanWire envia el mail de pago.
    );

    /**
     * Contenedor de la respuesta, si procesas, de la API.
     *
     * @var string
     */
    private $_buffer = '';

    /**
     * Almacenar el increment Id para que posteriormente sirva como nombre de la imagen de Código de Barras.
     *
     * @var string
     */
    private $_incrementId = '000000000';

    /**
     * El tipo de datos para requests y responses.
     *
     * @var string
     */
    private $_dataFormat = 'JSON';

    /**
     * Nombre del consumidor
     *
     * @var string
     */
    private $_customerName = '';

    /**
     * Email del consumidor
     *
     * @var string
     */
    private $_customerEmail = '';

    /**
     * Contenedor de la respuesta, procesada, de la API.
     *
     * @var array
     */
    private $_response = array();

    /**
     * Here you will need to implement authorize, capture and void public methods
     *
     * @see examples of transaction specific public methods such as
     * authorize, capture and void in Mage_Paygate_Model_Authorizenet
     */

    /**
     * Send authorize request to gateway
     *
     * @param  Mage_Payment_Model_Info $payment
     * @param  decimal $amount
     * @return Mage_Paygate_Model_Authorizenet
     */
    public function authorize(Varien_Object $payment, $amount)
    {
        #Mage::throwException(Mage::helper('paygate')->__('Invalid amount for authorization.'));

        if ($amount <= 0) {
            Mage::throwException(Mage::helper('paygate')->__('Invalid amount for authorization.'));
        }

        $this->__init($payment);

        if (FALSE === $this->_postRequest($payment, $amount)) {
            Mage::throwException(Mage::helper('paygate')->__('Error: ' . $this->_response['error_msg']));
        } else {
            if (FALSE === $this->_sendPdf) {
                $this->sendComprobante($payment);
            }

            # Grabar la información regresada por Banwire/Oxxo
            $payment->setAdditional_information(serialize($this->_response));
            $payment->setOxxo_cb(substr($this->_response['response']['barcode'], 2, 8));

            $payment->setTransactionId(substr($this->_response['response']['barcode'], 2, 8));
            $payment->setIsTransactionClosed(0);
            $payment->setTransactionAdditionalInfo(Mage_Sales_Model_Order_Payment_Transaction::RAW_DETAILS, array(
                'ID' => substr($this->_response['response']['barcode'], 2, 8)
                , 'barcode' => $this->_response['response']['barcode']
                , 'referencia' => $this->_response['response']['referencia']
                , 'fecha_vigencia' => $this->_response['response']['fecha_vigencia']
                , 'monto' => $this->_response['response']['monto']
                , 'path_img' => $this->_response['response']['path_img']
            ));
            $payment->setIsTransactionPending(false);
        }

        return $this;
    }

    /**
     * Post request to gateway and return response
     *
     * @param Mage_Paygate_Model_Authorizenet_Request $request)
     * @return Mage_Paygate_Model_Authorizenet_Result
     */
    protected function _postRequest($payment, $amount)
    {
        try {
            $this->_params['usuario'] = $this->_user;
            $this->_params['referencia'] = $this->_incrementId;
            $this->_params['dias_vigencia'] = $this->_daysInForce;
            $this->_params['monto'] = (float) $amount;
            $this->_params['url_respuesta'] = $this->_urlResponse;
            $this->_params['formato'] = $this->_dataFormat; // 'HTTPQUERY' ó 'JSON';

            $session = Mage::getSingleton('core/session');
            $session_customer_name = $session->getOxxoMobileCustomerName();

            if ($session_customer_name) {
                $this->_params['cliente'] = $session->getOxxoMobileCustomerName();
                $this->_params['email'] = $session->getOxxoMobileCustomerEmail();
                $this->_params['sendPDF'] = 'FALSE'; //$session->getOxxoMobileSendPdf();
            } else {
                $this->_params['cliente'] = $this->_customerName;
                $this->_params['email'] = $this->_customerEmail;
                $this->_params['sendPDF'] = $this->_sendPdf;
            }

            $send = $this->send();

            if ($send) {
                /*
                  Mage::log(__LINE__ . ': ' . __FILE__, 7, 'mylogfile.log');
                  Mage::log($this->_response, 7, 'mylogfile.log');
                 */
                $scBitacoras = (int) Mage::getStoreConfig('payment/banwireOxxo/bitacoras');
                if (1 == $scBitacoras) {
                    $contenido = print_r($this->_params, TRUE);
                    file_put_contents($this->_dirLog . 'BanwireOxxo_Payment.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $contenido . "\n\n", FILE_APPEND);
                }

                return TRUE;
            } else {
                /*
                  Mage::log(__LINE__ . ': ' . __FILE__, 7, 'mylogfile.log');
                  Mage::log($this->_params, 7, 'mylogfile.log');
                 */
                $contenido = print_r($this->_params, TRUE);
                file_put_contents($this->_dirLog . 'BanwireOxxo_Error.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $contenido . "\n\n", FILE_APPEND);

                return FALSE;
            }
        } catch (Exception $e) {
            /*
              Mage::log(__LINE__ . ': ' . __FILE__, 7, 'mylogfile.log');
              Mage::log($this->_params, 7, 'mylogfile.log');
             */
            return FALSE;
        }
    }

    /**
     * Funcion constructora.
     *
     * @param string $host Dirección de la API.
     * @param string $path Ruta donde se almacenara la imagen del código de barras.
     */
    public function __init($payment)
    {
        $this->_user = Mage::getStoreConfig('payment/banwireOxxo/merchant_id');
        $this->_path = Mage::getStoreConfig('payment/banwireOxxo/path_cb');
        $this->_sendPdf = 0 == (int) Mage::getStoreConfig('payment/banwireOxxo/send_pdf') ? FALSE : TRUE;
        $this->_urlResponse = Mage::getStoreConfig('payment/banwireOxxo/catch_response');
        $this->_daysInForce = Mage::getStoreConfig('payment/banwireOxxo/days_in_force');
        $this->_bitacoras = (int) Mage::getStoreConfig('payment/banwireOxxo/bitacoras');
        $this->_dirLog = Mage::getBaseDir('log') . self::BANWIRE_OXXO_DIRLOG;
        $this->_sendSeparateStub = 0 == (int) Mage::getStoreConfig('payment/banwireOxxo/separate_stub') ? FALSE : TRUE;

        # si al momento de hacer la compra, se está logueado en el sistema
        if (Mage::getSingleton('customer/session')->isLoggedIn()) {
            # Objeto customer
            $session = Mage::getSingleton('customer/session');
            $customer = $session->getCustomer();
            $this->_customerEmail = $customer->getEmail();
            $this->_customerName = $customer->getName();
        } else {
            # si no se está logueado
            $quote = Mage::getSingleton('checkout/session')->getQuote();
            $billingAddress = $quote->getBillingAddress();

            $this->_customerEmail = $billingAddress->getEmail();
            $this->_customerName = $billingAddress->getName();
        }

        # Objeto store
        //$storeId = (int) Mage::app()->getStore()->getId();
        ;

        /*
          Mage::log(__LINE__ . ': ' . __FILE__, 7, 'mylogfile.log');
          Mage::log('Store Id = ' . (string) $storeId, 7, 'mylogfile.log');
         */

        $order = $payment->getOrder();
        $incrementId = $order->getIncrementId();

        $this->_incrementId = empty($incrementId) ? $this->_incrementId : $incrementId;

        return $this;
    }

    /**
     *   Envia las variables al servidor de BanWire mediante
     * metodo POST usando cURL y procesa la respuesta.
     *
     * @params array $postfields Matriz, opcional, de variables a enviar.
     */
    public function send($postfields = array())
    {
        $postfields = empty($params) ? $this->_params : $params;
        if (!function_exists('curl_init'))
            return FALSE;
        if (!function_exists('http_build_query')) { // Crear cadena en formato http query
            foreach ($postfields as $i => $val)
                $pf .= urlencode($i) . '=' . urlencode($val) . "&";
            $pf = substr($pf, 0, strlen($pf) - 1);
        } else
            $pf = http_build_query($postfields);
        $postfields = $pf;
        $ch = curl_init(); // Iniciamos conexion cURL    
        curl_setopt($ch, CURLOPT_URL, $this->_host);
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/4.0 (compatible; MSIE 6.0; WINDOWS; .NET CLR 1.1.4322)');
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Accept-Charset' => 'utf-8,*'));
        curl_setopt($ch, CURLOPT_MAXREDIRS, 10);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_BINARYTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postfields);
        if (defined('CURLOPT_ENCODING'))
            curl_setopt($ch, CURLOPT_ENCODING, "");
        $this->_buffer = curl_exec($ch); // Almacenamos resultado
        if ($this->_buffer == null)
            return FALSE;
        if (!defined('CURLOPT_ENCODING'))
            return FALSE;
        curl_close($ch);

        return $this->_parseResponse();
    }

    /**
     * Procesa la respuesta de la API.
     *
     * @param string $buffer Respuesta de la API.
     */
    private function _parseResponse($buffer = '')
    {
        if (empty($buffer))
            $buffer = $this->_buffer;
        if (empty($buffer))
            return FALSE;
        switch (strtoupper($this->_params['formato'])) {
            case 'JSON':
                $this->_response = json_decode($buffer, TRUE);
                break;
            case 'HTTPQUERY':
            case 'HTTP_QUERY':
                parse_str($buffer, $this->_response);
                break;
            case 'XML':
                break;
            case 'ARRAY':
                break;
        }
        if ($this->_validateTransaction()) { // Transacción valida.
            $this->_generateFile();
            $this->_response['response']['path_img'] = $this->getPathImage();

            if (1 == $this->_bitacoras) {
                $contenido = print_r($this->_response, TRUE);
                file_put_contents($this->_dirLog . 'BanwireOxxo_Response.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $contenido . "\n\n", FILE_APPEND);
            }


            return TRUE;
        } else { // Error en la transacción.
            /*
              Mage::log(__LINE__ . ': ' . __FILE__, 7, 'Banwire_Oxxo.log');
              Mage::log('Error en la transaccion.', 7, 'Banwire_Oxxo.log');
              Mage::log($this->_response, 7, 'Banwire_Oxxo.log');
             */
            $contenido = print_r($this->_response, TRUE);
            file_put_contents($this->_dirLog . 'BanwireOxxo_Error.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $contenido . "\n\n", FILE_APPEND);
            return FALSE;
        }
    }

    /**
     * Valida que la transaccion haya sido exitosa.
     *
     * @return boolean.
     */
    private function _validateTransaction()
    {
        if (empty($this->_response))
            return FALSE;
        return !$this->_response['error'];
    }

    /**
     * Genera la imagen del codigo.
     */
    private function _generateFile()
    {
        file_put_contents($this->getPathImage(), base64_decode($this->_response['response']['barcode_img']));
        @chmod($this->getPathImage(), 0744);
        return TRUE;
    }

    /**
     * Obtiene la respuesta procesada de la API.
     *
     * @return array
     */
    public function getResponse()
    {
        return $this->_response; //($this->_response['error']) ? $this->_response : $this->_response['response'];
    }

    /**
     * Genera el nombre y la ruta donde sera almacenada la imagen del codigo de barras.
     *
     * @return string
     */
    public function getPathImage()
    {
        //return "$this->_path{$this->_params['referencia']}.png";
        return Mage::getBaseDir('media') . '/' . self::BANWIRE_OXXO_MEDIA_FOLDER . $this->_params['referencia'] . '_' . $this->_response['response']['barcode'] . '.png';
    }

    public function getError()
    {
        return ($this->_response['error']) ? $this->_response['error_msg'] : FALSE;
    }

    /**
     * Envía el talón de pago al consumidor.
     */
    public function sendComprobante($payment)
    {
        $templateId = Mage::getStoreConfig(self::XML_PATH_BANWIRE_OXXO_EMAIL_TEMPLATE);
        if (1 == $this->_bitacoras) {
            $contenido = $templateId;
            file_put_contents($this->_dirLog . 'BanwireOxxo_DebugTalon.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $contenido . "\n\n", FILE_APPEND);
        }

        $mailSubject = 'Tu talón de pago del pedido Num. ' . $payment->getOrderId();

        /**
         * $sender can be of type string or array. You can set identity of
         * diffrent Store emails (like 'support', 'sales', etc.) found
         * in "System->Configuration->General->Store Email Addresses"
         */
        $senderName = Mage::getStoreConfig('trans_email/ident_sales/name');
        $senderEmail = Mage::getStoreConfig('trans_email/ident_sales/email');
        $sender = array(
            'name' => $senderName,
            'email' => $senderEmail
        );
        if (1 == $this->_bitacoras) {
            $contenido = print_r($sender, TRUE);
            file_put_contents($this->_dirLog . 'BanwireOxxo_DebugTalon.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $contenido . "\n\n", FILE_APPEND);
        }

        /**
         * In case of multiple recipient use array here.
         */
        // Set recepient information
        $recepientEmail = $this->_customerEmail;
        $recepientName = $this->_customerName;

        // Get Store ID    
        $storeId = Mage::app()->getStore()->getId();

        // Set variables that can be used in email template
        $order = $payment->getOrder();

        $vars = array(
            'oxxo_id' => substr($this->_response['response']['barcode'], 2, 8)
            , 'oxxo_cb' => $this->_response['response']['barcode']
            , 'oxxo_monto' => '$' . number_format((double) $this->_response['response']['monto'], 2, '.', ',')
            , 'oxxo_fecha_vigencia' => $this->_response['response']['fecha_vigencia']
            , 'oxxo_path_img' => Mage::getBaseUrl('media') . self::BANWIRE_OXXO_MEDIA_FOLDER . $this->_incrementId . '_' . $this->_response['response']['barcode'] . '.png'
            , 'logo_banwoxxo' => Mage::getBaseUrl('media') . self::BANWIRE_OXXO_MEDIA_FOLDER . 'banwire-oxxo.png'
            , 'incrementId' => $this->_incrementId
            , 'order' => $order
            , 'transaction' => $this->_params
        );

        if (1 == $this->_bitacoras) {
            $contenido = print_r($vars['transaction'], TRUE);
            file_put_contents($this->_dirLog . 'BanwireOxxo_DebugTalon.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $contenido . "\n\n", FILE_APPEND);
        }
        $order->setOxxo_cb(substr($this->_response['response']['barcode'], 2, 8));

        /* Evitar el envío del cupón de Oxxo */
        if (TRUE === $this->_sendSeparateStub) {
            $translate = Mage::getSingleton('core/translate');

            // Send Transactional Email
            Mage::getModel('core/email_template')
                    ->setTemplateSubject($mailSubject)
                    ->sendTransactional($templateId, $sender, $recepientEmail, $recepientName, $vars, $storeId)
            ;

            $translate->setTranslateInline(true);
        }
        /* */

        $this->generarTalonPago($order, $vars);
    }

    protected function generarTalonPago(& $order, & $vars)
    {
        $talon = file_get_contents(__DIR__ . '/talonOxxo.html');
        if (1 == $this->_bitacoras) {
            $contenido = $talon;
            //file_put_contents($this->_dirLog . 'BanwireOxxo_DebugTalon.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $contenido . "\n\n", FILE_APPEND);
        }

        $campos = array(
            'order_number' => $this->_incrementId
            , 'customer_name' => $this->_customerName
            , 'store_name' => Mage::getStoreConfig('general/store_information/name')
            , 'store_url' => Mage::getBaseUrl()
            , 'logo_banwire_oxxo' => $vars['logo_banwoxxo']
            , 'logo_email' => $_logoUrl = Mage::getBaseUrl(Mage_Core_Model_Store::URL_TYPE_SKIN) . 'frontend/' . Mage::getDesign()->getPackageName() . '/' . Mage::getDesign()->getTheme('frontend') . '/images/logo_email.gif'
            , 'email_support' => Mage::getStoreConfig('trans_email/ident_support/email')
            , 'phone_support' => Mage::getStoreConfig('general/store_information/phone')
            , 'orden_fecha_hora' => $order->getCreatedAtFormated('long')
            , 'order_billing' => $order->getBillingAddress()->format('html')
            , 'oxxo_codigo_barras' => $vars['oxxo_path_img']
            , 'oxxo_vigencia' => $vars['oxxo_fecha_vigencia']
            , 'oxxo_codigo' => $vars['oxxo_cb']
            , 'oxxo_monto' => $vars['oxxo_monto']
        );

        foreach ($campos AS $key => $value) {
            $talon = str_replace('{{' . $key . '}}', $value, $talon);
        }


        $fileHtml = str_replace('.png', '.html', $this->getPathImage());

        if (1 == $this->_bitacoras) {
            $contenido = print_r($campos, TRUE);
            file_put_contents($this->_dirLog . 'BanwireOxxo_DebugTalon.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $contenido . "\n\n", FILE_APPEND);
        }

        if (1 == $this->_bitacoras) {
            $contenido = $fileHtml;
            file_put_contents($this->_dirLog . 'BanwireOxxo_DebugTalon.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $contenido . "\n\n", FILE_APPEND);
        }

        file_put_contents($fileHtml, $talon, 0);
    }

}
