<?php

/**
 * Our test CC module adapter
 * @update 2014-10-22
 */
class Magen4me_BanwirePro_Model_Payment extends Mage_Payment_Model_Method_Cc
{

    /**
     * unique internal payment method identifier
     *
     * @var string [a-z0-9_]
     */
    protected $_code = 'banwirePro';
    protected $_formBlockType = 'banwirePro/form_cc';
    protected $_autoInvoice = 0;
    protected $_aTipoTarjeta = array(
        'VI' => 'visa', 'MC' => 'mastercard', 'AE' => 'amex'
    );
    protected $_aCountryCode = array(
        'AX' => 'ALA'
        , 'AL' => 'ALB'
        , 'DZ' => 'DZA'
        , 'AS' => 'ASM'
        , 'AD' => 'AND'
        , 'AO' => 'AGO'
        , 'AI' => 'AIA'
        , 'AQ' => 'ATA'
        , 'AG' => 'ATG'
        , 'AR' => 'ARG'
        , 'AM' => 'ARM'
        , 'AW' => 'ABW'
        , 'AU' => 'AUS'
        , 'AT' => 'AUT'
        , 'AZ' => 'AZE'
        , 'BS' => 'BHS'
        , 'BH' => 'BHR'
        , 'BD' => 'BGD'
        , 'BB' => 'BRB'
        , 'BY' => 'BLR'
        , 'BE' => 'BEL'
        , 'BZ' => 'BLZ'
        , 'BJ' => 'BEN'
        , 'BM' => 'BMU'
        , 'BT' => 'BTN'
        , 'BO' => 'BOL'
        , 'BA' => 'BIH'
        , 'BW' => 'BWA'
        , 'BV' => 'BVT'
        , 'BR' => 'BRA'
        , 'VG' => 'VGB'
        , 'IO' => 'IOT'
        , 'BN' => 'BRN'
        , 'BG' => 'BGR'
        , 'BF' => 'BFA'
        , 'BI' => 'BDI'
        , 'KH' => 'KHM'
        , 'CM' => 'CMR'
        , 'CA' => 'CAN'
        , 'CV' => 'CPV'
        , 'KY' => 'CYM'
        , 'CF' => 'CAF'
        , 'TD' => 'TCD'
        , 'CL' => 'CHL'
        , 'CN' => 'CHN'
        , 'HK' => 'HKG'
        , 'MO' => 'MAC'
        , 'CX' => 'CXR'
        , 'CC' => 'CCK'
        , 'CO' => 'COL'
        , 'KM' => 'COM'
        , 'CG' => 'COG'
        , 'CD' => 'COD'
        , 'CK' => 'COK'
        , 'CR' => 'CRI'
        , 'CI' => 'CIV'
        , 'HR' => 'HRV'
        , 'CU' => 'CUB'
        , 'CY' => 'CYP'
        , 'CZ' => 'CZE'
        , 'DK' => 'DNK'
        , 'DJ' => 'DJI'
        , 'DM' => 'DMA'
        , 'DO' => 'DOM'
        , 'EC' => 'ECU'
        , 'EG' => 'EGY'
        , 'SV' => 'SLV'
        , 'GQ' => 'GNQ'
        , 'ER' => 'ERI'
        , 'EE' => 'EST'
        , 'ET' => 'ETH'
        , 'FK' => 'FLK'
        , 'FO' => 'FRO'
        , 'FJ' => 'FJI'
        , 'FI' => 'FIN'
        , 'FR' => 'FRA'
        , 'GF' => 'GUF'
        , 'PF' => 'PYF'
        , 'TF' => 'ATF'
        , 'GA' => 'GAB'
        , 'GM' => 'GMB'
        , 'GE' => 'GEO'
        , 'DE' => 'DEU'
        , 'GH' => 'GHA'
        , 'GI' => 'GIB'
        , 'GR' => 'GRC'
        , 'GL' => 'GRL'
        , 'GD' => 'GRD'
        , 'GP' => 'GLP'
        , 'GU' => 'GUM'
        , 'GT' => 'GTM'
        , 'GG' => 'GGY'
        , 'GN' => 'GIN'
        , 'GW' => 'GNB'
        , 'GY' => 'GUY'
        , 'HT' => 'HTI'
        , 'HM' => 'HMD'
        , 'VA' => 'VAT'
        , 'HN' => 'HND'
        , 'HU' => 'HUN'
        , 'IS' => 'ISL'
        , 'IN' => 'IND'
        , 'ID' => 'IDN'
        , 'IR' => 'IRN'
        , 'IQ' => 'IRQ'
        , 'IE' => 'IRL'
        , 'IM' => 'IMN'
        , 'IL' => 'ISR'
        , 'IT' => 'ITA'
        , 'JM' => 'JAM'
        , 'JP' => 'JPN'
        , 'JE' => 'JEY'
        , 'JO' => 'JOR'
        , 'KZ' => 'KAZ'
        , 'KE' => 'KEN'
        , 'KI' => 'KIR'
        , 'KP' => 'PRK'
        , 'KR' => 'KOR'
        , 'KW' => 'KWT'
        , 'KG' => 'KGZ'
        , 'LA' => 'LAO'
        , 'LV' => 'LVA'
        , 'LB' => 'LBN'
        , 'LS' => 'LSO'
        , 'LR' => 'LBR'
        , 'LY' => 'LBY'
        , 'LI' => 'LIE'
        , 'LT' => 'LTU'
        , 'LU' => 'LUX'
        , 'MK' => 'MKD'
        , 'MG' => 'MDG'
        , 'MW' => 'MWI'
        , 'MY' => 'MYS'
        , 'MV' => 'MDV'
        , 'ML' => 'MLI'
        , 'MT' => 'MLT'
        , 'MH' => 'MHL'
        , 'MQ' => 'MTQ'
        , 'MR' => 'MRT'
        , 'MU' => 'MUS'
        , 'YT' => 'MYT'
        , 'MX' => 'MEX'
        , 'FM' => 'FSM'
        , 'MD' => 'MDA'
        , 'MC' => 'MCO'
        , 'MN' => 'MNG'
        , 'ME' => 'MNE'
        , 'MS' => 'MSR'
        , 'MA' => 'MAR'
        , 'MZ' => 'MOZ'
        , 'MM' => 'MMR'
        , 'NA' => 'NAM'
        , 'NR' => 'NRU'
        , 'NP' => 'NPL'
        , 'NL' => 'NLD'
        , 'AN' => 'ANT'
        , 'NC' => 'NCL'
        , 'NZ' => 'NZL'
        , 'NI' => 'NIC'
        , 'NE' => 'NER'
        , 'NG' => 'NGA'
        , 'NU' => 'NIU'
        , 'NF' => 'NFK'
        , 'MP' => 'MNP'
        , 'NO' => 'NOR'
        , 'OM' => 'OMN'
        , 'PK' => 'PAK'
        , 'PW' => 'PLW'
        , 'PS' => 'PSE'
        , 'PA' => 'PAN'
        , 'PG' => 'PNG'
        , 'PY' => 'PRY'
        , 'PE' => 'PER'
        , 'PH' => 'PHL'
        , 'PN' => 'PCN'
        , 'PL' => 'POL'
        , 'PT' => 'PRT'
        , 'PR' => 'PRI'
        , 'QA' => 'QAT'
        , 'RE' => 'REU'
        , 'RO' => 'ROU'
        , 'RU' => 'RUS'
        , 'RW' => 'RWA'
        , 'BL' => 'BLM'
        , 'SH' => 'SHN'
        , 'KN' => 'KNA'
        , 'LC' => 'LCA'
        , 'MF' => 'MAF'
        , 'PM' => 'SPM'
        , 'VC' => 'VCT'
        , 'WS' => 'WSM'
        , 'SM' => 'SMR'
        , 'ST' => 'STP'
        , 'SA' => 'SAU'
        , 'SN' => 'SEN'
        , 'RS' => 'SRB'
        , 'SC' => 'SYC'
        , 'SL' => 'SLE'
        , 'SG' => 'SGP'
        , 'SK' => 'SVK'
        , 'SI' => 'SVN'
        , 'SB' => 'SLB'
        , 'SO' => 'SOM'
        , 'ZA' => 'ZAF'
        , 'GS' => 'SGS'
        , 'SS' => 'SSD'
        , 'ES' => 'ESP'
        , 'LK' => 'LKA'
        , 'SD' => 'SDN'
        , 'SR' => 'SUR'
        , 'SJ' => 'SJM'
        , 'SZ' => 'SWZ'
        , 'SE' => 'SWE'
        , 'CH' => 'CHE'
        , 'SY' => 'SYR'
        , 'TW' => 'TWN'
        , 'TJ' => 'TJK'
        , 'TZ' => 'TZA'
        , 'TH' => 'THA'
        , 'TL' => 'TLS'
        , 'TG' => 'TGO'
        , 'TK' => 'TKL'
        , 'TO' => 'TON'
        , 'TT' => 'TTO'
        , 'TN' => 'TUN'
        , 'TR' => 'TUR'
        , 'TM' => 'TKM'
        , 'TC' => 'TCA'
        , 'TV' => 'TUV'
        , 'UG' => 'UGA'
        , 'UA' => 'UKR'
        , 'AE' => 'ARE'
        , 'GB' => 'GBR'
        , 'US' => 'USA'
        , 'UM' => 'UMI'
        , 'UY' => 'URY'
        , 'UZ' => 'UZB'
        , 'VU' => 'VUT'
        , 'VE' => 'VEN'
        , 'VN' => 'VNM'
        , 'VI' => 'VIR'
        , 'WF' => 'WLF'
        , 'EH' => 'ESH'
        , 'YE' => 'YEM'
        , 'ZM' => 'ZMB'
        , 'ZW' => 'ZWE'
    );
    protected $_dirLog = '/Payment/Banwire/';
    protected $_banwireCcFields = array(
        'user' => 'Nombre de usuario en BanWire.com. 3-30',
        'CUST_IP' => 'Dirección IP desde donde se realiza la compra',
        'ebWEBSITE' => 'URL del sitio web del comercio. 8-60',
        'PROD_DEL_CD' => 'Tipo de producto que se comercializa. 3',
        # DATOS DE LA TRANSACCION
        'ORD_CURR_CD' => 'Tipo de moneda MXN | USD. 3',
        'ORD_ID' => 'El numero del pedido de Magento 3-22',
        'ORD_AMT' => 'Monto total a pagar. 2-12 con 2 decimales',
        'ORD_CONCEPT' => 'Concepto de pago. 3-30',
        # DATOS DE TARJETA
        'CARD_NUM' => 'Número en la tarjeta. 15-16',
        'CARD_OWN' => 'Nombre en la tarjeta. 10-30',
        'CARD_TYPE' => 'Tipo de tarjeta visa | mastercard | amex. 4-30',
        'CARD_EXP_DT' => 'Expiración de la tarjeta MMYY. 4',
        'CARD_CVV' => 'Código de Seguridad de la tarjeta. 3 VISA, MC | 4 AMEX',
        'CARD_AVS_ADDR' => 'Calle 5-30',
        'CARD_AVS_ZIPCODE' => 'C.P.',
        # DATOS DEL COMPRADOR
        'CUST_USER_ID' => 'ID del usuario. 3-16',
        'CUST_PHONE' => 'Teléfono. 5-19',
        'CUST_EMAIL' => 'Correo electrónico. 8-60',
        'CUST_FNAME' => 'Nombre. 2-30',
        'CUST_LNAME' => 'Apellido Paterno. 2-30',
        'CUST_MNAME' => 'Apellido Materno. 1',
        'CUST_WORK_PHONE' => 'Teléfono de trabajo. 5-19',
        'CUST_ADDR1' => 'Dirección. 5-30',
        'CUST_CITY' => 'Ciudad. 3-20',
        'CUST_STPR_CD' => 'Estado. 2',
        'CUST_POSTAL_CD' => 'Código Postal. 5',
        'CUST_CNTRY_CD' => 'País  (código del país de acuerdo al estándar ISO). 3',
        # DATOS DE ENVIO
        'SHIP_ID' => 'ID del usuario. 3-16',
        'SHIP_FNAME' => 'Nombre. 2-30',
        'SHIP_LNAME' => 'Apellido Paterno. 2-30',
        'SHIP_MNAME' => 'Apellido Materno. 1',
        'SHIP_EMAIL' => 'Correo electrónico. 8-60',
        'SHIP_HOME_PHONE' => 'Teléfono. 5-19',
        'SHIP_ADDR1' => 'Dirección. 5-30',
        'SHIP_CITY' => 'Ciudad. 3-20',
        'SHIP_STPR_CD' => 'Estado. 2',
        'SHIP_CNTRY_CD' => 'País  (código del país de acuerdo al estándar ISO). 3',
        'SHIP_POSTAL_CD' => 'Código Postal. 5',
        'SHIP_MTHD_CD' => 'Método de envío'
    );


    /**
     * Here are examples of flags that will determine functionality availability
     * of this module to be used by frontend and backend.
     *
     * @see all flags and their defaults in Mage_Payment_Model_Method_Abstract
     *
     * It is possible to have a custom dynamic logic by overloading
     * public function can* for each flag respectively
     */

    /**
     * Is this payment method a gateway (online auth/charge) ?
     */
    protected $_isGateway = true;

    /**
     * Can authorize online?
     */
    protected $_canAuthorize = true;

    /**
     * Can capture funds online?
     */
    protected $_canCapture = false;

    /**
     * Can capture partial amounts online?
     */
    protected $_canCapturePartial = false;

    /**
     * Can refund online?
     */
    protected $_canRefund = false;

    /**
     * Can void transactions online?
     */
    protected $_canVoid = true;

    /**
     * Can use this payment method in administration panel?
     */
    protected $_canUseInternal = true;

    /**
     * Can show this payment method as an option on checkout payment page?
     */
    protected $_canUseCheckout = true;

    /**
     * Is this payment method suitable for multi-shipping checkout?
     */
    protected $_canUseForMultishipping = true;

    /**
     * Can save credit card information for future processing?
     */
    protected $_canSaveCc = TRUE;
    protected $_canReviewPayment = TRUE;

    /**
     * Here you will need to implement authorize, capture and void public methods
     *
     * @see examples of transaction specific public methods such as
     * authorize, capture and void in Mage_Paygate_Model_Authorizenet
     */

    /**
     * Send authorize request to gateway
     *
     * @param  Mage_Payment_Model_Info $payment
     * @param  decimal $amount
     * @return Mage_Paygate_Model_Authorizenet
     */
    const EMAIL_TEMPLATE_XML_PATH = 'payment/banwirePro/email_template';

    public function authorize(Varien_Object $payment, $amount)
    {
        if ($amount <= 0) {
            Mage::throwException(Mage::helper('banwirePro')->__('Invalid amount for authorization.'));
        }

        $response = $this->_postRequest($payment, $amount);

        $success = TRUE;
        $errorCode = 0;
        if (isset($response->code)) {
            $success = FALSE;
            $codigoBanwire = '';
            if (isset($response->parameter)) {
                $codigoBanwire = $this->_banwireCcFields[$response->parameter];
            }
            $mensaje = '[ ' . $response->code . ' ] - ' . Mage::helper('banwirePro')->__($response->message) . ' >>> ' . $codigoBanwire;
            $errorCode = (int) $response->code;
            if (500 == $errorCode) {
                $mensaje = 'Gracias por su compra, su pago está en revisión para ser procesado.';
                Mage::getSingleton('core/session')->addNotice($mensaje);
            } else {
                Mage::throwException($mensaje);
            }
        }
        if (isset($response->ERROR_CODE)) {
            $success = FALSE;
            $mensaje = '[ ' . $response->ERROR_CODE . ' ] - ' . Mage::helper('banwirePro')->__($response->ERROR_MSG) . ' >>> XXXX-XXXX-XXXX-' . $response->CARD;
            $errorCode = (int) $response->ERROR_CODE;
            if (500 == $errorCode) {
                $mensaje = 'Gracias por su compra, su pago está en revisión para ser procesado.';
                Mage::getSingleton('core/session')->addNotice($mensaje);
            } else {
                Mage::throwException($mensaje);
            }
        }

        # crear transaction
        $authCode = NULL;
        if (!isset($response->code) && !isset($response->ERROR_CODE)) {
            $cerrarTransaction = 1;
            $authCode = $response->AUTH_CODE;
        }

        if (TRUE === $success) {
            $payment->setTransactionId($response->ID);
            $payment->setIsTransactionClosed(0);
            $payment->setTransactionAdditionalInfo(Mage_Sales_Model_Order_Payment_Transaction::RAW_DETAILS, array(
                'ID' => $response->ID
                , 'CARD' => $response->CARD
                , 'ORD_ID' => $response->ORD_ID
                , 'AUTH_CODE' => $authCode
            ));
        }

        if (500 == $errorCode) {
            $payment->setTransactionId($response->ID);
            $payment->setIsTransactionClosed(0);
            $payment->setIsTransactionPending(true);
            # no marcar como "sospecho de fraude"
            //$payment->setIsFraudDetected(true);
        }

        return $this;
    }

    /**
     * Attempt to accept a payment that us under review
     *
     * @param Mage_Payment_Model_Info $payment
     * @return bool
     * @throws Mage_Core_Exception
     */
    public function acceptPayment(Mage_Payment_Model_Info $payment)
    {
        parent::acceptPayment($payment);
        //perform gateway actions to remove Fraud flags. Capture should not occur here
        return true;
        //returning true will trigger a capture on any existing invoices, otherwise the admin can manually Invoice the order
    }

    /**
     * Attempt to deny a payment that us under review
     *
     * @param Mage_Payment_Model_Info $payment
     * @return bool
     * @throws Mage_Core_Exception
     */
    public function denyPayment(Mage_Payment_Model_Info $payment)
    {
        parent::denyPayment($payment);
        //if your payment gateway supports it, you should probably void any pre-auth
        return true;
    }

    /**
     * Post request to gateway and return response
     *
     * @param Mage_Paygate_Model_Authorizenet_Request $request)
     * @return Mage_Paygate_Model_Authorizenet_Result
     */
    protected function _postRequest(& $payment, $amount)
    {
        $dir_log = Mage::getBaseDir('log') . $this->_dirLog;

        $storeId = (int) Mage::app()->getStore()->getId();

        # recolectar los valores de la tienda para el plugin
        $scMerchantId = Mage::getStoreConfig('payment/banwirePro/merchant_id');
        $scSubmitUrl = Mage::getStoreConfig('payment/banwirePro/submit_url');
        $scUseNotifyUrl = (int) Mage::getStoreConfig('payment/banwirePro/use_notify_url');
        $scNotifyUrl = Mage::getStoreConfig('payment/banwirePro/notify_url');
        $scOrdConcept = Mage::getStoreConfig('payment/banwirePro/ord_concept');
        $scProdDelCd = Mage::getStoreConfig('payment/banwirePro/prod_del_cd');
        $scShipMthdCd = Mage::getStoreConfig('payment/banwirePro/ship_mthd_cd');
        $scDebugMode = (int) Mage::getStoreConfig('payment/banwirePro/debug_mode');
        $scBitacoras = (int) Mage::getStoreConfig('payment/banwirePro/bitacoras');

        $configStatus = Mage::getStoreConfig('payment/banwirePro/order_status');
        $this->_autoInvoice = (int) Mage::getStoreConfig('payment/banwirePro/autoinvoice');

        $storeName = Mage::getStoreConfig('general/store_information/name');
        $website = Mage::getStoreConfig('web/secure/base_url');
        $visitorData = Mage::getSingleton('core/session')->getVisitorData();
        $customerIp = Mage::helper('core/http')->getRemoteAddr(FALSE);

        # determinar si la compra se está haciendo desde el backend
        $adminSession = Mage::getSingleton('admin/session');
        $adminLoggedIn = $adminSession->isLoggedIn();
        if ($adminLoggedIn) {
            $quote = Mage::getSingleton('adminhtml/session_quote')->getQuote();
        } else {
            $quote = Mage::getSingleton('checkout/session')->getQuote();
        }

        # obtener los objetos principales del proceso de compra
        $billingAddress = $quote->getBillingAddress();
        $shippingAddress = $quote->getShippingAddress();

        $abillingCalle = $billingAddress->getStreet();
        $billingCalle = $abillingCalle[0] . ' ' . $abillingCalle[1];

        $ashipingCalle = $shippingAddress->getStreet();
        $shipingCalle = $ashipingCalle[0] . ' ' . $ashipingCalle[1];

        $orderId = $payment->getOrder()->getIncrementId();

        # si al momento de hacer la compra, se está logueado en el sistema
        if (Mage::getSingleton('customer/session')->isLoggedIn()) {
            $customer = Mage::getSingleton('customer/session')->getCustomer();
            $customerId = substr('0000000000000000' . trim((string) $customer->getId()), -16, 16);
            $fullname = $customer->getName();
            $firstname = $customer->getFirstname();
            $lastname = $customer->getLastname();
            $email = $customer->getEmail();

            # vamos a establecer la variable EBT_PREVCUST
            $customerOrders = Mage::getResourceModel('sales/order_collection')
                    //->addFieldToSelect('*')
                    ->addFieldToSelect('customer_id')
                    ->addFieldToFilter('customer_id', $customer->getId())
                    ->addAttributeToSort('created_at', 'DESC')
                    ->setPageSize(1);
            $customerOrders->getFirstItem()->getId();
            $ebtPrevCust = empty($customerOrders) ? 'N' : 'Y';
        } else {
            if ($adminLoggedIn) { // está logueado en el backend
                $customerId = substr('0000000000000000' . trim((string) $quote->getId()), -16, 16);
                $ebtPrevCust = 'Y';

                $emailOrder = Mage::app()->getRequest()->getParam('order');
                $email = $emailOrder['account']['email'];
                if ('' == trim($email)) {
                    $customer = Mage::getSingleton('adminhtml/session_quote')->getCustomer();
                    $email = $customer->getEmail();
                }
            } else { // no está logueado ni el front, ni en el backend
                $customerId = '9000000000000000';
                $ebtPrevCust = 'N';
                $email = $billingAddress->getEmail();
            }
            # si no se está logueado
            $fullname = $billingAddress->getName();
            $firstname = $billingAddress->getFirstname();
            $lastname = $billingAddress->getLastname();
        }

        $ebtDevicePrint = Mage::app()->getRequest()->getParam('EBT_DEVICEPRINT');
        $requestBilling = Mage::app()->getRequest()->getParam('billing');
        $requestShipping = Mage::app()->getRequest()->getParam('shipping');

        $custWorkPhone = $shipHomePhone = '00000';

        if (!isset($requestBilling['telephone'])) {
            //$this->getCustomer()->getPrimaryBillingAddress()->getTelephone();
            $custWorkPhone = substr($billingAddress->getTelephone(), 0, 19);
            if (5 > strlen($custWorkPhone)) {
                $custWorkPhone = '00000';
            }
        } else {
            $custWorkPhone = substr($requestBilling['telephone'], 0, 19);
        }
        if (!isset($requestShipping['telephone'])) {
            $shipHomePhone = substr($shippingAddress->getTelephone(), 0, 19);
            if (5 > strlen($shipHomePhone)) {
                $shipHomePhone = $custWorkPhone;
            }
        } else {
            $shipHomePhone = substr($requestShipping['telephone'], 0, 19);
        }

        if (1 == $scDebugMode) {
            $contenido = print_r(Mage::app()->getRequest()->getParams(), TRUE);
            //date_default_timezone_set('America/Mexico_City');
            file_put_contents($dir_log . 'Banwire_Debug.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $contenido . "\n\n", FILE_APPEND);
        }

        $custWorkPhone = Mage::helper('banwirePro')->normalizarTelefono($custWorkPhone);
        $shipHomePhone = Mage::helper('banwirePro')->normalizarTelefono($shipHomePhone);

        if ('' == trim($shipHomePhone)) {
            $shipHomePhone = $custWorkPhone;
        }

        # validaciones extras
        if ('' == trim($custWorkPhone)) {
            $custWorkPhone = $shipHomePhone;
        }
        if (5 > strlen($custWorkPhone)) {
            $custWorkPhone = '00000' . $custWorkPhone;
        }
        if (5 > strlen($shipHomePhone)) {
            $shipHomePhone = '00000' . $shipHomePhone;
        }
        #

        $cardNumCrypt = Mage::helper('banwirePro')->enmascararTarjeta($payment->getCcNumber());
        $custCntryCd = $this->_aCountryCode[$billingAddress->getCountryId()];
        $custCntryCdShip = '' !== trim($shippingAddress->getCountryId()) ? $this->_aCountryCode[$shippingAddress->getCountryId()] : $custCntryCd;

        # Fix para los acentos 2015-03-10
        $custStprCD2 = trim(substr($billingAddress->getRegion(), 0, 5)) . 'XXXXX';
        $custStprCD_X = Mage::helper('banwirePro')->quitarAcentos($custStprCD2);
        $custStprCD = substr(strtoupper($custStprCD_X), 0, 2);
        $shipStprCD2 = '' != trim($shippingAddress->getRegion()) ? trim(substr($shippingAddress->getRegion(), 0, 5)) . 'XXXXX' : $custStprCD;
        $shipStprCD_X = Mage::helper('banwirePro')->quitarAcentos($shipStprCD2);
        $shipStprCD = substr(strtoupper($shipStprCD_X), 0, 2);

        $aDatos = array(
            # Tipo de respuesta.
            'response_format' => 'JSON', // Formato de la respues HTTPQUERY | JSON
            # PARAMETROS ESPECIALES
            'user' => $scMerchantId, // Nombre de usuario en BanWire.com. 3-30
            'EBT_PREVCUST' => $ebtPrevCust, // Cliente habitual: Acepta los valores Y o N. 1
            'EBT_DEVICEPRINT' => $ebtDevicePrint, // Es el identificador del dispositivo desde el cual se realiza la compra (PC Finger Print) (Ver sección detalles de variables). 2000-4000
            'CUST_IP' => $customerIp, // Dirección IP desde donde se realiza la compra. 7-15
            'ebWEBSITE' => $website, // URL del sitio web del comercio. 8-60
            'PROD_DEL_CD' => $scProdDelCd, // Tipo de producto que se comercializa** (consultar detalle de variables). 3
            # DATOS DE LA TRANSACCION
            'ORD_CURR_CD' => Mage::app()->getStore()->getCurrentCurrencyCode(), // Tipo de moneda MXN | USD. 3
            'ORD_ID' => $orderId, // El numero del pedido de Magento 3-22
            'ORD_AMT' => number_format($this->_setCurrencyAmount($amount), 2, '.', ''), // Monto total a pagar. 2-12 con 2 decimales
            'ORD_CONCEPT' => substr(str_replace('{{store_name}}', $storeName, $scOrdConcept), 0, 30), // Concepto de pago. 3-30
            # DATOS DE TARJETA
            'CARD_NUM' => $payment->getCcNumber(), // Número en la tarjeta. 15-16
            'CARD_OWN' => strtoupper($payment->getCcOwner()), // Nombre en la tarjeta. 10-30
            'CARD_TYPE' => $this->_aTipoTarjeta[$payment->getCcType()], // Tipo de tarjeta visa | mastercard | amex. 4-30
            'CARD_EXP_DT' => substr('00' . $payment->getCcExpMonth(), -2, 2) . substr($payment->getCcExpYear(), -2, 2), // Expiración de la tarjeta MMYY. 4
            'CARD_CVV' => $payment->getCcCid(), // Código de Seguridad de la tarjeta. 3 VISA, MC | 4 AMEX
            'CARD_AVS_ADDR' => substr($billingCalle, 0, 30), // 5-30
            //'CARD_AVS_ADDR' => substr($payment->getCcAddress(), 0, 30), // 5-30
            'CARD_AVS_ZIPCODE' => substr('00000' . $billingAddress->getPostcode(), -5, 5),
            //'CARD_AVS_ZIPCODE' => $payment->getCcPostalcode(),
            # DATOS DEL COMPRADOR
            'CUST_USER_ID' => $customerId, // ID del usuario. 3-16
            'CUST_PHONE' => $custWorkPhone, // Teléfono. 5-19
            'CUST_EMAIL' => substr($email, 0, 60), // Correo electrónico. 8-60
            'CUST_FNAME' => substr($firstname, 0, 30), // Nombre. 2-30
            'CUST_LNAME' => substr($lastname, 0, 30), // Apellido Paterno. 2-30
            'CUST_MNAME' => substr($firstname, 0, 1), // Apellido Materno. 1
            'CUST_WORK_PHONE' => $custWorkPhone, // Teléfono de trabajo. 5-19
            'CUST_ADDR1' => substr($billingCalle, 0, 30), // Dirección. 5-30
            'CUST_CITY' => substr($billingAddress->getCity(), 0, 20), // Ciudad. 3-20
            'CUST_STPR_CD' => $custStprCD, // Estado. 2
            'CUST_POSTAL_CD' => substr('00000' . $billingAddress->getPostcode(), -5, 5), // Código Postal. 5
            'CUST_CNTRY_CD' => $custCntryCd, // País  (código del país de acuerdo al estándar ISO). 3, ref: http://www.nationsonline.org/oneworld/country_code_list.htm
            # DATOS DE ENVIO
            'SHIP_ID' => $customerId, // ID del usuario. 3-16
            'SHIP_FNAME' => '' != trim($shippingAddress->getFirstname()) ? substr($shippingAddress->getFirstname(), 0, 30) : substr($firstname, 0, 30), // Nombre. 2-30
            'SHIP_LNAME' => '' != trim($shippingAddress->getLastname()) ? substr($shippingAddress->getLastname(), 0, 30) : substr($lastname, 0, 30), // Apellido Paterno. 2-30
            'SHIP_MNAME' => '' != trim($shippingAddress->getFirstname()) ? substr($shippingAddress->getFirstname(), 0, 1) : substr($firstname, 0, 1), // Apellido Materno. 1
            'SHIP_EMAIL' => '' != trim($shippingAddress->getEmail()) ? substr($shippingAddress->getEmail(), 0, 60) : substr($email, 0, 60), // Correo electrónico. 8-60
            'SHIP_HOME_PHONE' => $shipHomePhone, // Teléfono. 5-19
            'SHIP_ADDR1' => '' != trim($shipingCalle) ? substr($shipingCalle, 0, 19) : substr($billingCalle, 0, 30), // Dirección. 5-30
            'SHIP_CITY' => '' != trim($shippingAddress->getCity()) ? substr($shippingAddress->getCity(), 0, 20) : substr($billingAddress->getCity(), 0, 20), // Ciudad. 3-20
            'SHIP_STPR_CD' => $shipStprCD, // Estado. 2
            'SHIP_CNTRY_CD' => $custCntryCdShip, // País  (código del país de acuerdo al estándar ISO). 3, ref http://www.nationsonline.org/oneworld/country_code_list.htm
            'SHIP_POSTAL_CD' => substr('00000' . $shippingAddress->getPostcode(), -5, 5), // Código Postal. 5
            'SHIP_MTHD_CD' => $scShipMthdCd, // Método de envío** (consultar detalle de variables)
        );
        if (1 == $scUseNotifyUrl) {
            $aDatos['NOTIFY_URL'] = $scNotifyUrl; // URL donde el servidor de BanWire enviará el status final de los pagos que pasaron por revisión 10-128
        }

        # Fill var items
        $cartItems = Mage::getSingleton('checkout/session')->getQuote()->getAllItems();
        $xi = 1;
        $aProducts = array();
        foreach ($cartItems as $item) {
            # DATOS DE LOS PRODUCTOS
            # [X] debe ser sustituido por el número de artículo de compra. 
            # Aun cuando sea un solo artículo el que exista en el carrito, se debe sustituir [X] por 1. 
            # Por ejemplo: ITEM_QTY1
            /* Fix para manejar productos complejos: configurable, groupe, bundle.
              $aDatos['ITEM_QTY' . (string) $xi] = $item->getQty(); // Cantidad a comprar del articulo [X]. 1-5
              $aDatos['ITEM_CST_AMT' . (string) $xi] = number_format($item->getPrice(), 2, '.', ''); // Costo del artículo [X]  (Acepta hasta 2 decimales). 1-10
              $aDatos['ITEM_AMT' . (string) $xi] = number_format($item->getQty() * $item->getPrice(), 2, '.', ''); // Costo total = Costo del artículo [X]  por la cantidad de artículos[X] (Acepta hasta 2 decimales). 1-10
              $aDatos['ITEM_DESC' . (string) $xi] = substr($item->getName(), 0, 127); // Nombre o Descripción del articulo [X]. 5-127
              ++$xi;
             */

            if ($item->getHasChildren()) {
                foreach ($item->getChildren() as $child) {
                    $priceCurrencyChild = $this->_setCurrencyAmount($child->getPrice());
                    $priceCurrencyItem = $this->_setCurrencyAmount($item->getPrice());

                    $priceItem = $priceCurrencyItem + $priceCurrencyChild;
                    $priceItemTotal = $item->getQty() * $priceItem;

                    $aDatos['ITEM_QTY' . (string) $xi] = $item->getQty(); // Cantidad a comprar del articulo [X]. 1-5
                    $aDatos['ITEM_CST_AMT' . (string) $xi] = number_format($priceItem, 2, '.', ''); // Costo del artículo [X]  (Acepta hasta 2 decimales). 1-10
                    $aDatos['ITEM_AMT' . (string) $xi] = number_format($priceItemTotal, 2, '.', ''); // Costo total = Costo del artículo [X]  por la cantidad de artículos[X] (Acepta hasta 2 decimales). 1-10
                    $aDatos['ITEM_DESC' . (string) $xi] = substr($child->getName(), 0, 127); // Nombre o Descripción del articulo [X]. 5-127
                    ++$xi;
                }
            } else {
                if (0 == (int) $item->getPrice()) {
                    continue;
                }

                $priceCurrency = $this->_setCurrencyAmount($item->getPrice());

                $aDatos['ITEM_QTY' . (string) $xi] = $item->getQty(); // Cantidad a comprar del articulo [X]. 1-5
                $aDatos['ITEM_CST_AMT' . (string) $xi] = number_format($priceCurrency, 2, '.', ''); // Costo del artículo [X]  (Acepta hasta 2 decimales). 1-10
                $aDatos['ITEM_AMT' . (string) $xi] = number_format($item->getQty() * $priceCurrency, 2, '.', ''); // Costo total = Costo del artículo [X]  por la cantidad de artículos[X] (Acepta hasta 2 decimales). 1-10
                $aDatos['ITEM_DESC' . (string) $xi] = substr($item->getName(), 0, 127); // Nombre o Descripción del articulo [X]. 5-127
                ++$xi;
            }
        }

        $params = array_merge($aDatos, $aProducts);

        error_reporting(E_ALL);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $scSubmitUrl);
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/4.0 (compatible; MSIE 6.0; WINDOWS; .NET CLR 1.1.4322)');
        curl_setopt($ch, CURLOPT_MAXREDIRS, 10);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params));
        if (defined('CURLOPT_ENCODING')) {
            curl_setopt($ch, CURLOPT_ENCODING, "");
        }

        if (1 == $scBitacoras) {
            $xparams = $params;
            $xparams['CARD_NUM'] = $cardNumCrypt;
            $contenido = print_r($xparams, TRUE);
            file_put_contents($dir_log . 'Banwire_Payment.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $contenido . "\n\n", FILE_APPEND);
        }
        try {
            if (1 == $scDebugMode) {
                $jsonResponse = $this->_debuggingResponse($cardNumCrypt, $orderId); // para probar y no mandar la petición.
            } else {
                $jsonResponse = curl_exec($ch);
            }

            $_response = json_decode($jsonResponse);

            foreach ($_response as $_key => $_value) {
                $_payment_data[$_key] = $_value;
            }

            if (!isset($_response->ID) OR ! isset($_response->ORD_ID)) {
                # no hubo comunicación con la plataforma de pagos.
                if (1 == $scBitacoras) {
                    file_put_contents($dir_log . 'Banwire_Debug.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\nOrden - " . $orderId . "\n\n", FILE_APPEND);
                    $jsonPrint = print_r($_response, TRUE);
                    file_put_contents($dir_log . 'Banwire_Debug.log', "jsonResponse: \n" . $jsonPrint . "\n\n", FILE_APPEND);
                }
                $exceptionMsg = $orderId . ' - ' . $email . ' >>> Error in payment gateway.' . "\n";

                # hay excepciones que tratar
                if (isset($_response->ERROR_CODE)) {
                    $code_err = $_response->ERROR_CODE;
                    $error = $_response->ERROR_CODE . ' - ' . $_response->ERROR_CODE . ' >>> ' . $_response->ERROR_PARAMETER;
                } else {
                    $code_err = $_response->code;
                    $error22 = '';
                    if (isset($_response->parameter)) {
                        if (array_key_exists($_response->parameter, $this->_banwireCcFields)) {
                            $error22 = ' >>> ' . $this->_banwireCcFields[$_response->parameter];
                        }
                    }
                    $error = $_response->code . ' - ' . $_response->message . ' >>> ' . $_response->parameter . $error22;
                }

                file_put_contents($dir_log . 'Banwire_Error.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $exceptionMsg . "\n" . $error . "\n\n", FILE_APPEND);
                Mage::throwException(Mage::helper('paygate')->__($error));
            }

            if (!isset($_response->ERROR_CODE) && !isset($_response->ERROR_MSG) && isset($_response->ID) && isset($_response->CARD) && isset($_response->ORD_ID) && isset($_response->AUTH_CODE)) {
                # Success
                $state = $configStatus;

                $payment->setLastTransId($orderId)
                        ->setCcApproval($_response->AUTH_CODE)
                        ->setStatus(self::STATUS_APPROVED)
                        ->setAmount($amount)
                        ->setAdditional_information(serialize($_payment_data))
                ;

                if (1 == $scBitacoras) {
                    $responseBanw = print_r($_response, TRUE);
                    file_put_contents($dir_log . 'Banwire_Response.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $responseBanw . "\n\n", FILE_APPEND);
                }

                # facturar, el evento de facturación automáticamente pone el state = Complete a la orden                
                $this->_invoicedOrder($payment->getOrder(), $configStatus);

                $order = $payment->getOrder();
                $order->addStatusHistoryComment('Auth code: "' . $_response->AUTH_CODE . '"', false);
                $order->save();

                if (1 == $scBitacoras) {
                    file_put_contents($dir_log . 'Banwire_Debug.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\nFacturado - [" . $orderId . "] " . $configStatus . "\n\n", FILE_APPEND);
                }
            } else {
                # hay excepciones que tratar
                if (isset($_response->ERROR_CODE)) {
                    $code_err = $_response->ERROR_CODE;
                    $error = $_response->ERROR_CODE . ' - ' . $_response->ERROR_CODE . ' >>> ' . $_response->ERROR_PARAMETER;
                } else {
                    $code_err = $_response->code;
                    $error = $_response->code . ' - ' . $_response->message . ' >>> ' . $_response->parameter;
                }

                $order = $payment->getOrder();

                if (500 == (int) $code_err) {
                    # Pendiente, pasa a revisión manual
                    $order->setCustomerNoteNotify(false);
                    $order->addStatusHistoryComment('***[500] - Pasa a revisión manual por Banwire', false);
                    $order->save();

                    $payment->setLastTransId($orderId)
                            ->setCcStatus($code_err)
                            ->setCcStatusDescription($error)
                            ->setAmount($amount)
                            ->setAdditional_information(serialize($_payment_data))
                    ;

                    # los errores siempre se graban en el archivo .log, sin importar si están activados los errores
                    # en el store config
                    # DATOS DE TARJETA
                    $responseBanw['CARD_NUM'] = $cardNumCrypt;
                    $responseBanw['CARD_OWN'] = $aDatos['CARD_OWN'];
                    $responseBanw['CARD_TYPE'] = $aDatos['CARD_TYPE'];
                    $responseBanw['CARD_EXP_DT'] = $aDatos['CARD_EXP_DT'];
                    $responseBanw['CARD_CVV'] = $aDatos['CARD_CVV'];
                    $responseBanw['CARD_AVS_ADDR'] = $aDatos['CARD_AVS_ADDR'];
                    $responseBanw['CARD_AVS_ZIPCODE'] = $aDatos['CARD_AVS_ZIPCODE'];

                    $contenido = print_r($_response, TRUE) . "\n" . print_r($responseBanw, TRUE);
                    file_put_contents($dir_log . 'Banwire_Payment_Review.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $contenido . "\n\n", FILE_APPEND);
                } else {
                    # Rechazado, seguramente código 501 o 0
                    # evito cancelar la orden, para que pueda intentarlo, por lo tanto, se queda como NEW
                    //$state = Mage_Sales_Model_Order::STATE_CANCELED;
                    //$order->setState($state)->save();

                    $payment->setLastTransId($orderId)
                            ->setCcStatus($code_err)
                            ->setCcStatusDescription($error)
                            ->setStatus(self::STATUS_DECLINED)
                            ->setAmount($amount)
                            ->setAdditional_information(serialize($_payment_data))
                    ;
                    # los errores siempre se graban en el archivo .log, sin importar si están activados los errores
                    # en el store config
                    $responseBanw = print_r($_response, TRUE);
                    file_put_contents($dir_log . 'Banwire_Error.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $responseBanw . "\n\n", FILE_APPEND);
                }
            }

            return $_response;
        } catch (Exception $e) {
            $exceptionMsg = 'An exception was launched:' . "\n[" . $e->getCode() . '] - ' . $e->getMessage();
            file_put_contents($dir_log . 'Banwire_Error.log', "-------" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $exceptionMsg . "\n\n", FILE_APPEND);
            Mage::throwException(Mage::helper('paygate')->__('Error in payment gateway.'));

            return false;
        }
    }

    /**
     * crea la factura sin notificar al cliente
     * @param object $order
     * @param string $status
     */
    private function _invoicedOrder($order, $status)
    {
        if ('processing' == $status OR 'complete' == $status) {
            if ($order->canInvoice() && 1 === $this->_autoInvoice) {
                $invoice = $order->prepareInvoice();
                $invoice->setRequestedCaptureCase(Mage_Sales_Model_Order_Invoice::CAPTURE_OFFLINE);
                $invoice->register();

                $order->setCustomerNoteNotify(false);
                $order->setIsInProcess(true);
                $order->addStatusHistoryComment('Automatically INVOICED by Banwire.', false);

                $transactionSave = Mage::getModel('core/resource_transaction');
                $transactionSave->addObject($invoice)->addObject($invoice->getOrder());
                $transactionSave->save();
            }
        }
    }

    public function _setCurrencyAmount($amount)
    {
        $baseCurrencyCode = Mage::app()->getStore()->getBaseCurrencyCode();
        $currentCurrencyCode = Mage::app()->getStore()->getCurrentCurrencyCode();

        // convert price from current currency to base currency
        //$priceOne = Mage::helper('directory')->currencyConvert($price, $currentCurrencyCode, $baseCurrencyCode);
        // convert price from base currency to current currency
        $currencyAmount = Mage::helper('directory')->currencyConvert($amount, $baseCurrencyCode, $currentCurrencyCode);

        return $currencyAmount;
    }

    /**
     * Genera una respuesta aleatoria para efectos de debuguear y probar.
     * 
     * @param String $card El número de la tarjeta
     * @param String $order El número de la orden
     * @return Object
     */
    private function _debuggingResponse($card, $order)
    {
        $randomito = $this->_getDebugResponses();

        $objResponse = new stdClass();
        $objResponse->ID = rand(100000, 999999);
        $objResponse->CARD = substr($card, -4, 4);
        $objResponse->ORD_ID = $order;
        /*
          [ID] => 342305
          [CARD] => 5584
          [ORD_ID] => 100000248
          [ERROR_CODE] => 501
          [ERROR_MSG] => La transacción ha sido denegada por seguridad.
         */

        switch ($randomito) {
            case 1:
                # denegado
                $objResponse->ERROR_CODE = 501;
                $objResponse->ERROR_MSG = 'La transacción ha sido denegada por seguridad.';
                break;
            case 3:
                # payment review
                $objResponse->ERROR_CODE = 500;
                $objResponse->ERROR_MSG = 'La transacción ha pasado a validación de seguridad.';
                break;
            case 4:
                # error de la plataforma
                unset($objResponse->ID);
                unset($objResponse->CARD);
                unset($objResponse->ORD_ID);
                $objResponse->code = 500;
                $objResponse->message = 'Error interno del servidor.';
                break;
            default:
                # success   
                $objResponse->AUTH_CODE = substr('00' . (string) rand(1000, 999999), -6, 6);
                break;
        }

        return json_encode($objResponse);
    }

    private function _getDebugResponses()
    {
        $configResponses = (int) Mage::getStoreConfig('payment/banwirePro/tryresponses');

        if (5 == $configResponses) {
            $randomito = rand(1, 2);
        }

        if (0 == $configResponses) {
            $randomito = rand(1, 4);
        } else {
            $randomito = $configResponses;
        }

        return $randomito;
    }

}
