<?php

/**
 * Envia mediante libreria cURL
 * @param url  Url de envio
 * @param postfields Array o query string con las variables a enviar
 * @urlencoded Enviar url encoded?
 * @port Puerto de transmisión
 */
function send_curl($url, $postfields, $urlencoded = TRUE, $port = NULL)
{
    if (!function_exists('curl_init'))
        return FALSE;
    else {
        if ($urlencoded == TRUE) {
            if (is_array($postfields))
                $postfields = http_build_query($postfields);
        }
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/4.0 (compatible; MSIE 6.0; WINDOWS; .NET CLR 1.1.4322)');
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Accept-Charset' => 'utf-8,*'));
        curl_setopt($ch, CURLOPT_MAXREDIRS, 10);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_VERBOSE, 1); // Debug
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postfields);
        if (!empty($port))
            curl_setopt($ch, CURLOPT_PORT, $port);
        if (defined('CURLOPT_ENCODING'))
            curl_setopt($ch, CURLOPT_ENCODING, '');
        $res = curl_exec($ch);
        if ($res == NULL)
            return FALSE;
        if (!defined('CURLOPT_ENCODING'))
            return FALSE;
        curl_close($ch);
    }
    return $res;
}

//$url = 'https://banwire.com/solicitud_pago.oxxo/_key,R3p3UWZXYVVPRVU9/';
//$url = 'http://testing.lokald.com/banwire_UFC3920/oxxo/catch_response.php';
$url = 'http://www.lokald.com/banwire_UFC3920/oxxo/catch_response.php';
$post = array(
    'plaza' => 'Mexico',
    'tienda' => 'Alvaro Obregon MEX',
    'fecha' => '20140228',
    'hora' => '14:34',
    //'cb' => '21000069842010100500309007000000000000000000000000',
    //'cb' => '00211941',
    'cb' => '21002118272014030900410002000000000000000000000000',
    //'referencia' => '56058',
    //'referencia' => '100000078',
    'referencia' => '000000000',
    'monto' => '410.00',
    'flag' => '1'
);
echo send_curl($url, $post);
