<?php

/**
 * Cacha la respuesta de Banwire para las órdenes en Revisión
 * @version 0.1.0
 * @author Ultiminio Ramos <contacto@ultiminioramos.com>
 */
/*
  echo '<pre>';
  ini_set('display_errors', '1');
 */
require '../../app/Mage.php';
Mage::App(); //might be "default"

if (!Mage::isInstalled()) {
    echo "Application is not installed yet, please complete install wizard first.";
    exit;
}

// Only for urls
// Don't remove this
$_SERVER['SCRIPT_NAME'] = str_replace(basename(__FILE__), 'index.php', $_SERVER['SCRIPT_NAME']);
$_SERVER['SCRIPT_FILENAME'] = str_replace(basename(__FILE__), 'index.php', $_SERVER['SCRIPT_FILENAME']);

#Mage::getModel('emailnewsletter/emailnewsletter')->getCurrentProducts();
require 'Mage/Core/Helper/Data.php';
//echo Mage::helper('mihelper')->fecha_legible_gmt_mx();
//echo "\n";

define('DIR_LOG', '/Payment/Banwire/');

$dir_log = Mage::getBaseDir('log') . DIR_LOG;
$scBitacoras = (int) Mage::getStoreConfig('payment/banwirePro/bitacoras');

if (isset($_REQUEST['ORD_ID'])) {
    try {
        $incrementId = trim($_REQUEST['ORD_ID']);
        $order = Mage::getModel('sales/order')
                ->load($incrementId, 'increment_id')
        ;

        $datosOrden = $order->getData();

        //$contenidoT = print_r($order->getData(), TRUE);

        if (0 == count($datosOrden)) {
            $contenido = print_r($_REQUEST, TRUE); // . "\n\n" . $contenidoT;
            date_default_timezone_set('America/Mexico_City');
            file_put_contents($dir_log . 'Banwire_notify_catch_error.log', "=======" . date('Y-m-d H:i:s') . "\n" . $contenido . "\n\n", FILE_APPEND);

            die();
        }

        $payment = $order->getPayment($order);

        # instanciar la clase Payment
        $banwirePro = new Magen4me_BanwirePro_Model_Payment();

        /**
         * change order status to 'Completed'
         */
        if (!isset($_REQUEST['ERROR_CODE']) && 'ok' == strtolower($_REQUEST['STATUS'])) {
            //$order->setState(Mage_Sales_Model_Order::STATE_COMPLETE, true)->save();
            $comment = '<b>El pago ya fue revisado, autorizado y aplicado por Banwire.</b>';
            $comment.= '<br/>';
            $comment.= '<b>Auth code:</b> ' . $_REQUEST['AUTH_CODE'] . '<br/>';

            $status = Mage::getStoreConfig('payment/banwirePro/order_status');
            
            $order->addStatusHistoryComment($comment, $status);
            $order->setData('state', $status);
            $order->save();

            $banwirePro->acceptPayment($payment);

            #Autoinvoice
            invoicedOrder($order);

            # crear transaction
            //$transactionId = $order->getPayment()->getLastTransId();

            $contenido = print_r($transactionId, TRUE);
            date_default_timezone_set('America/Mexico_City');
            file_put_contents($dir_log . 'Chanclas.log', "=======" . date('Y-m-d H:i:s') . "\n" . $contenido . "\n\n", FILE_APPEND);

            # enviar comprobantes
            sendComprobante($order);
        } else {
            //$order->setState(Mage_Sales_Model_Order::STATE_COMPLETE, true)->save();
            $comment = '<b>Banwire ha revisado manualmente el pago y lo ha rechazado.</b>';
            $comment.= '<br/>';
            $comment.= '<b>Error:</b> [' . $_REQUEST['ERROR_CODE'] . ']';
            $comment.= '<br/>';
            $comment.= '<b>Reason:</b> ' . $_REQUEST['ERROR_MSG'] . '<br/>';

            $order->addStatusHistoryComment($comment, Mage_Sales_Model_Order::STATE_CANCELED);
            $order->setData('state', Mage_Sales_Model_Order::STATE_CANCELED);
            $order->save();

            $banwirePro->denyPayment($payment);
            sendComprobante($order, 2);
        }

        # solamente despliego datos para modo de testing, comentar en producción
        $payment_extra = $payment->getAdditionalInformation();
        $ultimo = end($payment_extra);
        $key = key($payment_extra);

        if (1 == $scBitacoras) {
            $contenido = print_r($_REQUEST, TRUE);
            date_default_timezone_set('America/Mexico_City');
            file_put_contents($dir_log . 'Banwire_notify_catch_complete_or_fail.log', "=======" . date('Y-m-d H:i:s') . "\n" . $contenido . "\n\n", FILE_APPEND);
        }
    } catch (Exception $e) {
        print_r($e->getMessage());
        echo '</pre>';
        $contenido = print_r($e->getMessage(), TRUE);
        date_default_timezone_set('America/Mexico_City');
        file_put_contents($dir_log . 'Banwire_notify_catch_error.log', "=======" . date('Y-m-d H:i:s') . "\n" . $contenido . "\n\n", FILE_APPEND);
    }
} else {
    
}

function sendComprobante(& $order, $template = NULL)
{
    # preparación de datos
    $payment = $order->getPayment($order);
    $payment_extra = $payment->getAdditionalInformation();

    $mailSubject = 'Revisión aprobada x Banwire, #' . $payment->getOrderId();

    /**
     * $sender can be of type string or array. You can set identity of
     * diffrent Store emails (like 'support', 'sales', etc.) found
     * in "System->Configuration->General->Store Email Addresses"
     */
    $senderName = Mage::getStoreConfig('trans_email/ident_sales/name');
    $senderEmail = Mage::getStoreConfig('trans_email/ident_sales/email');
    $salesEmailOrderCopyTo = Mage::getStoreConfig('sales_email/order/copy_to');

    /**
     * In case of multiple recipient use array here.
     */
    // Set recepient information
    //$recepientEmail = $order->getCustomerEmail();
    //$recepientName = $order->getCustomerName();
    // Get Store ID    
    $storeId = Mage::app()->getStore()->getId();

    // Set variables that can be used in email template

    if (NULL === $template) {
        $vars = array(
            'authCode' => $_REQUEST['AUTH_CODE']
            , 'card' => '**** ' . $_REQUEST['CARD']
            , 'incrementId' => $order->getIncrementId()
            , 'order' => $order
        );

        $emailTpl = 'catch_response_banwirePro_email_template';
    } else {
        $vars = array(
            'error' => $_REQUEST['ERROR_CODE']
            , 'errorMsg' => '**** ' . $_REQUEST['ERROR_MSG']
            , 'card' => '**** ' . $_REQUEST['CARD']
            , 'incrementId' => $order->getIncrementId()
            , 'order' => $order
        );
        $emailTpl = 'catch_response_banwirePro_emailfail_template';
    }

    // Send Transactional Email
    $sender = array(
        'name' => $senderName,
        'email' => $senderEmail
    );
    $destinatarios = explode(',', $salesEmailOrderCopyTo);
    foreach ($destinatarios as $recepientEmail) {
        Mage::getModel('core/email_template')
                ->loadDefault($emailTpl)
                ->setTemplateSubject($mailSubject)
                ->sendTransactional($emailTpl, $sender, $recepientEmail, '', $vars, $storeId)
        ;
    }

    #enviar al customer
    $billingAddress = $order->getBillingAddress();
    $customerEmail = $billingAddress->getEmail();
    $customerName = $billingAddress->getName();

    if (1 == $scBitacoras) {
        date_default_timezone_set('America/Mexico_City');
        $dir_log = Mage::getBaseDir('log') . DIR_LOG;
        file_put_contents($dir_log . 'Banwire_notify_catch_complete_or_fail_debug.log', "=======" . date('Y-m-d H:i:s') . "\n" . '$customerEmail: ' . $customerEmail . "\n" . '$customerName: ' . $customerName . "\n\n", FILE_APPEND);
    }
    Mage::getModel('core/email_template')
            ->loadDefault($emailTpl)
            ->setTemplateSubject($mailSubject)
            ->sendTransactional($emailTpl, $sender, $customerEmail, $customerName, $vars, $storeId)
    ;
}

/**
 * crea la factura sin notificar al cliente
 * @param object $order
 * @param string $status
 */
function invoicedOrder(& $order)
{
    $autoInvoice = (int) Mage::getStoreConfig('payment/banwirePro/autoinvoice');
    if (1 === $autoInvoice) {
        $invoice = $order->prepareInvoice();
        $invoice->setRequestedCaptureCase(Mage_Sales_Model_Order_Invoice::CAPTURE_OFFLINE);
        $invoice->register();

        $order->setCustomerNoteNotify(false);
        $order->setIsInProcess(true);
        $order->addStatusHistoryComment('Automatically INVOICED by Banwire.', false);
        /*
          $order->getPayment()->setSkipTransactionCreation(false);
          $order->getPayment()->setIsTransactionClosed();
         */

        $transactionSave = Mage::getModel('core/resource_transaction');
        $transactionSave->addObject($invoice)->addObject($invoice->getOrder());
        $transactionSave->save();
    }
}
