<?php

/**
 * Cacha la respuesta de Banwire cuando se especifica la variable NOTIFY_URL
 * @version 0.1.0
 * @author Ultiminio Ramos <ultiminio.r@d8mbi.com>
 */
//echo '<pre>';
//ini_set('display_errors', '1');

require '../../app/Mage.php';
Mage::App(); //might be "default"

if (!Mage::isInstalled()) {
    echo "Application is not installed yet, please complete install wizard first.";
    exit;
}

// Only for urls
// Don't remove this
$_SERVER['SCRIPT_NAME'] = str_replace(basename(__FILE__), 'index.php', $_SERVER['SCRIPT_NAME']);
$_SERVER['SCRIPT_FILENAME'] = str_replace(basename(__FILE__), 'index.php', $_SERVER['SCRIPT_FILENAME']);

#Mage::getModel('emailnewsletter/emailnewsletter')->getCurrentProducts();
require 'Mage/Core/Helper/Data.php';

define('DIR_LOG', '/Payment/Banwire/');

$dir_log = Mage::getBaseDir('log') . DIR_LOG;

date_default_timezone_set('America/Mexico_City');
if (isset($_REQUEST['id'])) {
    try {
        $orderId = trim($_REQUEST['id']);
        echo "<pre>" . $orderId . "<br/>";
        
        $order = Mage::getModel('sales/order')->loadByIncrementId($orderId);

        $order->setState(Mage_Sales_Model_Order::STATE_PAYMENT_REVIEW, true);
        $order->setStatus(Mage_Sales_Model_Order::STATE_PAYMENT_REVIEW, true)->save();
        echo 'Change to '.Mage_Sales_Model_Order::STATE_PAYMENT_REVIEW.': Ok';
        echo '</pre>';
    } catch (Exception $e) {
        $contenido = print_r($e->getMessage(), TRUE);
        file_put_contents($dir_log . 'Banwire_set_order_state.log', "=======" . date('Y-m-d H:i:s') . "\n" . $contenido . "\n\n", FILE_APPEND);
    }
} else {
    echo "<pre>" . date('Y-m-d H:i:s') . "</pre>";
}
